%define module_name HO-class
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/ISA.pm) perl(Module/Build.pm) perl(Package/Subroutine.pm) perl(Test/AbstractMethod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(base.pm) perl(subs.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.080
Release: alt1
Summary: class builder for hierarchical objects
Group: Development/Perl
License: perl
URL: https://github.com/p5-ho-develop/class/tree/master

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SK/SKNPP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a simple class builder for array based objects. Normally it does
its job during compile time. A constructor new is build. The generated
new will initialize each member with an appropriate default value.

The method `init' is reserved for setting up objects during construction.
This method gets the fresh build object, and the arguments given calling `new'.
A little questionable optimization is that the call to `init' is not build
into the constructor when no such method exists or the option `init' is not
part of `HO::class-\'import> call.

For that reason the pragma `subs' is often used, before `HO::class'.

Five different keys could be used, to define different accessors.

=over 4

=item `_rw'

The generated accessor can read and write the data.

=item `_ro'

The accessor is for read access only.

=item `_lvalue'

=item `_method'

=item `_index'

=back

The second field is name of the part from class
which will be created. Third field is used for datatype or
code references.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/H*

%changelog
