# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(JSON/PP.pm) perl(Scalar/Util.pm) perl(Test2/V0.pm) perl(feature.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name HTML-Blitz-Builder
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1101
Release: alt1
Summary: create HTML code dynamically and safely
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MAUKE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is useful for creating snippets of HTML code (or entire documents)
programmatically. It takes care of automatically escaping any strings you pass
to it, which prevents the injection of HTML and script code (XSS).

To use it, call the `mk_elem', `mk_comment', and `mk_doctype' constructor
functions as needed to create the document structure you want. At the very end,
pass everything to `to_html' to obtain the corresponding HTML code.

The basic data structure used by this module is the document fragment, which in
Perl is represented as a list of (zero or more) node values. A node value is
one of the following:

=over

=item *

A text node, represented by a plain string.

=item *

An element node, represented by an object returned from `mk_elem'.

=item *

A comment node, represented by an object returned from `mk_comment'.

=item *

A `DOCTYPE' declaration, represented by an object returned from `mk_doctype'.

=back

See below for the list of public functions provided by this module, which are
exportable on request.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes COPYING README
%perl_vendor_privlib/H*

%changelog
