%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Email/Valid.pm) perl(ExtUtils/MakeMaker.pm) perl(Geography/Countries.pm) perl(HTML/FormatData.pm) perl(LWP/UserAgent.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(URI/Find.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name HTML-CheckArgs
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Validate data passed to web applications
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/EF/EFOLLEY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
HTML::CheckArgs validates data passed to web applications. Architecturally,
it is based on CGI::Untaint, and we follow that model of extensibility
as well.

Most of the work is done in the $config hashref. $config's keys are the
fieldnames to be validated. The following parameters can be passed in:

=over

=item as:

Name of the module that should be used to validate the data. The following modules
are available:

=over

=item cc_expiration

Passed a date string in the format YYYYMM, will determine if the string is valid, and
if the date is in the future.

=item cc_number

Validates credit card numbers based on Luhn checksum.

=item country

Validates 2-character country code or full country name per Georgraphy::Countries.

=item date

Passed a date string, a format, and a regex of the format, will determine if the string
represents a valid date.

=item dollar

Validates a dollar figure. Can optionally specify minimum and maximum vaues to check
against.

=item email

Uses Email::Valid to check email addresses. Can optionally specify no administrative
addresses (e.g. root@domain.com), no government addresses (me@dot.gov), or no addresses
from a list of domains passed to the module.

=item integer

Determines if number is a valid interger. Can optionally specify minimum and maximum
values to check against.

=item option

Determines if a value is a member of a list passed to the module. Useful when the form
input is a select or a radio button.

=item phone

Determines if a string is valid phone number. Only does strict validation on US phone numbers,
but other formats could be included.

=item postal_code

Validates a postal  or ZIP code. Only does strict validation on US ZIP codes.

=item state

Validates a two-character state abbrieviation or full name. Only does strict validation
on US values.

=item string

A catch-all class. Can format the string per the routines in HTML::FormatData, and can
also do regex checks, checks on the number of character, number of words, etc.

=item url

Uses URL::Find to validate the URL. Can optionally check the URL via LWP::UserAgent.

=back

=item required:

Set to 1 if the field is required. Default is 0 (not required).

=item order:

The order the fields should be evaluated in.

=item label:

Field name label to be used for user error messages.

=item private:

A flag that can be passed to your error reporting instrument as an 
indicator of whether the error should be displayed to the user. Default
is 0.

=item params:

Extra parameters that should be passed to the specific module
validating the data. Passing parameters to a module that does not support
use this feature will cause it to 'die'. Passing unknown parameters will
also cause it to 'die'.

=item noclean:

Determines if the value returned should be cleaned up if the value is validated.
Set to 1 to preserve the original value. Default is 0 (value will be cleaned).
Some modules do not support cleaning the input. If you pass 'noclean' to one of
these modules, it will 'die'.

=item untaint:

Set to 1 if you want the value to be untainted. Default is 0 (don't untaint).

Please note that all untainting is done after a successful is_valid call to
the specific validation module. If a value is_valid, we assume it is safe to
untaint it without further checks, so the regex pattern /(.*)/s is used. 
If you want more rigorous checking, it is advisable that you improve the
is_valid code or do alternate checks before untainting the value.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/H*

%changelog
