%define module_name HTML-DeferableCSS
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(Devel/StrictMode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(List/Util.pm) perl(Module/Metadata.pm) perl(Moo.pm) perl(MooX/TypeTiny.pm) perl(Path/Tiny.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/CleanNamespaces.pm) perl(Test/Deep.pm) perl(Test/EOL.pm) perl(Test/Fixme.pm) perl(Test/Kwalitee.pm) perl(Test/MinimumVersion.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Test/NoTabs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Types/Common/Numeric.pm) perl(Types/Common/String.pm) perl(Types/Path/Tiny.pm) perl(Types/Standard.pm) perl(constant.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.4.2
Release: alt1
Summary: Simplify management of stylesheets in your HTML
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RR/RRWO/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This is an experimental module for generating HTML-snippets for
deferable stylesheets.

This allows the stylesheets to be loaded asynchronously, allowing the
page to be rendered faster.

Ideally, this would be a simple matter of changing stylesheet links
to something like

  <link rel="preload" as="stylesheet" href="....">

but this is not well supported by all web browsers. So a web page
needs some JavaScript
to handle this, as well as a `noscript' block as a fallback.

This module allows you to simplify the management of stylesheets for a
web application, from development to production by

=over

=item *

declaring all stylesheets used by your web application;

=item *

specifying remote aliases for stylesheets, e.g. from a CDN;

=item *

enable or disable the use of minified stylesheets;

=item *

switch between local copies of stylesheets or CDN versions;

=item *

automatically inline small stylesheets;

=item *

use deferred-loading stylesheets, which requires embedding JavaScript
code as a workaround for web browsers that do not support these
natively.

=back

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/H*
%perl_vendor_privlib/auto/*

%changelog
