Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Catalyst.pm) perl(Catalyst/Runtime.pm) perl(Data/UUID.pm) perl(Encode.pm) perl(GD/SecurityImage.pm) perl(HTML/Entities.pm) perl(HTTP/Date.pm) perl(Test/EOL.pm) perl(Test/NoTabs.pm) perl(Type/Tiny.pm) perl(Type/Tiny/Enum.pm) perl(charnames.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-HTML-FormHandler
Version:        0.40068
Release:        alt2_25
Summary:        HTML forms using Moose
License:        GPL-1.0-or-later OR Artistic-1.0-Perl

URL:            https://metacpan.org/release/HTML-FormHandler
Source0:        https://cpan.metacpan.org/authors/id/G/GS/GSHANK/HTML-FormHandler-%{version}.tar.gz

BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(aliased.pm)
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Class/Load.pm)
BuildRequires:  perl(Config/Any.pm)
BuildRequires:  perl(Crypt/Blowfish.pm)
BuildRequires:  perl(Crypt/CBC.pm)
BuildRequires:  perl(Data/Clone.pm)
BuildRequires:  perl(DateTime.pm)
BuildRequires:  perl(DateTime/Format/Strptime.pm)
BuildRequires:  perl(Email/Valid.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/ShareDir.pm)
BuildRequires:  perl(File/ShareDir/Install.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(HTML/TreeBuilder.pm)
BuildRequires:  perl(JSON/MaybeXS.pm)
BuildRequires:  perl(List/AllUtils.pm)
BuildRequires:  perl(Locale/Maketext.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(Moose/Role.pm)
BuildRequires:  perl(MooseX/Getopt.pm)
BuildRequires:  perl(MooseX/Types.pm)
BuildRequires:  perl(MooseX/Types/Common.pm)
BuildRequires:  perl(MooseX/Types/LoadableClass.pm)
BuildRequires:  perl(namespace/autoclean.pm)
BuildRequires:  perl(PadWalker.pm)
BuildRequires:  perl(Sub/Exporter.pm)
BuildRequires:  perl(Sub/Name.pm)
BuildRequires:  perl(Template.pm)
BuildRequires:  perl(Test/Differences.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/Memory/Cycle.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Warn.pm)
BuildRequires:  perl(Try/Tiny.pm)
BuildRequires:  perl(utf8.pm)
Requires:       perl(Class/Load.pm) >= 0.060
Requires:       perl(Locale/Maketext.pm) >= 1.090
Requires:       perl(Moose.pm) >= 2.000.700
Requires:       perl(MooseX/Getopt.pm) >= 0.160
Requires:       perl(MooseX/Types.pm) >= 0.200
Requires:       perl(MooseX/Types/Common.pm)
Requires:       perl(MooseX/Types/LoadableClass.pm) >= 0.006
Requires:       perl(namespace/autoclean.pm) >= 0.090

# hidden from Pause
Provides:       perl(HTML/FormHandler/Meta/Role.pm) = %{version}
Provides:       perl(HTML/FormHandler/Model/CDBI.pm) = %{version}
Provides:       perl(HTML/FormHandler/Params.pm) = %{version}
Provides:       perl(HTML/FormHandler/Field/Repeatable/Instance.pm) = %{version}


Source44: import.info

%description
HTML::FormHandler is a form handling class that validates HTML form data and,
for database forms, saves it to the database on validation. It has field
classes that can be used for creating a set of widgets and highly automatic
templates. There are two simple rendering roles plus a set of widget roles for
individual form and field classes. FormHandler is designed to make it easy to
produce alternative rendering modules.

%prep
%setup -q -n HTML-FormHandler-%{version}

find lib -type f -print0 | xargs -0 chmod 644

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}

# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README TODO
%doc --no-dereference LICENSE
%{perl_vendor_privlib}/*

%changelog
