# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/HTML5/Entities.pm) perl(HTML/HTML5/Writer.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(XML/LibXML.pm) perl(common/sense.pm)
# END SourceDeps(oneline)
%define module_version 0.004
%define module_name HTML-HTML5-Builder
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: erect some scaffolding for your documents
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/HTML-HTML5-Builder

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module can export function names corresponding to any HTML5 element.

Each function returns an XML::LibXML::Element with the same name as the
function. The arguments to each function are processed as a list, and
used to set the attributes and contents of that element.

For each item on the list:

=over

=item * if it's an XML::LibXML::Element, XML::LibXML::TextNode,
XML::LibXML::Comment, or XML::LibXML::PI, it's appended as a
child of the returned element.

=item * if it's an XML::LibXML::NodeList, each item on the list is
appended as a child of the returned element.

=item * if it's an XML::LibXML::Attr, it's set as an attribute on
the returned element

=item * if it's an IO::Handle, then it will be slurped and appended
to the returned element as a text node.

=item * if it's a scalar reference, then the returned element is also
assigned to it. (This feature is at risk.)

=item * if it's a scalar (string) some guesswork is conducted to figure
out whether you're setting an attribute and value, or whether the string
should be used as a text node. The presence of a hyphen at the start of
the string is the main deciding factor.

  p('-class', 'warning', '$LordLucan not found.');

In this example, a paragraph element is returned, with the class attribute
set to 'warning' and the textual contents '$LordLucan not found.'.

Sometimes it's necessary to protect values against this guesswork. By
passing a hashref, all the keys and values are interpreted as setting
attributes; by passing an arrayref, all values are interpreted as setting
the contents of the element.

  p(['-class'], { warning => '$LordLucan not found.' });

In this example, a paragraph element is returned, with the warning attribute
set to '$LordLucan not found.' and the textual contents '-class'.

=item * Anything else is stringified and added as a text node. This is
useful for things with sensible stringification defined, such as `DateTime'
and `URI' objects, but less so for some other objects, so you will
sometimes get a warning if warnings are enabled. Warnings can be disabled
using:

  no warnings 'HTML::HTML::Builder';

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README examples
%perl_vendor_privlib/H*

%changelog
