# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(HTML/HTML5/Parser.pm) perl(HTML/HTML5/Sanity.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(RDF/Trine.pm) perl(RDF/Trine/Namespace.pm) perl(RDF/Trine/Node/Literal/XML.pm) perl(Socket.pm) perl(Test/More.pm) perl(Test/RDF.pm) perl(URI/Escape.pm) perl(URI/URL.pm) perl(XML/LibXML.pm) perl(base.pm) perl(inc/Module/Package.pm) perl(overload.pm) perl(DBD/SQLite.pm)
# END SourceDeps(oneline)
%define module_version 0.100
%define module_name HTML-HTML5-Microdata-Parser
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.100
Release: alt1
Summary: fairly experimental parser for HTML 'microdata'
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/HTML-HTML5-Microdata-Parser

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This package aims to have a roughly compatible API to RDF::RDFa::Parser.

Microdata is an experimental metadata format, not in wide use. Use this module
at your own risk.

=over 8

=item $p = HTML::HTML5::Microdata::Parser->new($html, $baseuri, \%%options, $storage)

This method creates a new HTML::HTML5::Microdata::Parser object and returns it.

The $xhtml variable may contain an XHTML/XML string, or a
XML::LibXML::Document. If a string, the document is parsed using
HTML::HTML5::Parser and HTML::HTML5::Sanity, which may throw an
exception. HTML::HTML5::Microdata::Parser does not catch the exception.

The base URI is used to resolve relative URIs found in the document.

Options [default in brackets]:

  * alt_stylesheet  - Magic rel="alternate stylesheet". [1]
  * auto_config     - See section "Auto Config" [0]
  * mhe_lang        - Process <meta http-equiv=Content-Language>.
                      [1]
  * prefix_empty    - URI prefix for itemprops of untyped items.
                      [undef]
  * strategy        - URI generation strategy for itemprops of
                      typed items. [HTML::HTML5::Microdata::
                      Strategy::Heuristic]
  * tdb_service     - thing-described-by.org when possible. [0] 
  * xhtml_base      - Process <base href> element. [1]
  * xhtml_lang      - Process @lang. [1]
  * xhtml_meta      - Process <meta>. [0]
  * xhtml_cite      - Process @cite. [0]
  * xhtml_rel       - Process @rel. [0]
  * xhtml_time      - Process <time> element more nicely. [0]
  * xhtml_title     - Process <title> element. [0]
  * xml_lang        - Process @xml:lang. [1]

$storage is an RDF::Trine::Storage object. If undef, then a new
temporary store is created.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE examples
%perl_vendor_privlib/H*

%changelog
