Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       perl-HTML-LinkList 
Version:    0.1701
Release:    alt2_31
# lib/HTML/LinkList.pm -> GPL+ or Artistic
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:    GPL-1.0-or-later OR Artistic-1.0-Perl 

Summary:    Create a 'smart' list of HTML links
Source:     https://cpan.metacpan.org/authors/id/R/RU/RUBYKAT/HTML-LinkList-%{version}.tar.gz
Url:        https://metacpan.org/release/HTML-LinkList

BuildArch:     noarch
BuildRequires: rpm-build-perl
BuildRequires: perl-devel
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Pod/Coverage/TrustPod.pm)
BuildRequires: perl(Test/CPAN/Meta.pm)
BuildRequires: perl(Test/HasVersion.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Pod.pm)
BuildRequires: perl(Test/Pod/Coverage.pm)
BuildRequires: perl(Test/Portability/Files.pm)
BuildRequires: perl(blib.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)


Source44: import.info

%description
This module contains a number of functions for taking sets of URLs and
labels and creating suitably formatted HTML. These links are "smart"
because, if given the url of the current page, if any of the links in
the list equal it, that item in the list will be formatted as a special
label, not as a link; this is a Good Thing, since the user would be
confused by clicking on a link back to the current page. While many
website systems have plugins for "smart" navbars, they are specialized
for that system only, and can't be reused elsewhere, forcing people to
reinvent the wheel. I hereby present one wheel, free to be reused by
anybody; just the simple functions, a backend, which can be plugged into
whatever system you want.The default format for the HTML is to make an
unordered list, but there are many options, enabling one to have a
flatter layout with any separators you desire, or a more complicated
list with differing formats for different levels.



%prep
%setup -q -n HTML-LinkList-%{version}

%build
/usr/bin/perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
RELEASE_TESTING=1 ./Build test

%files
%doc Changes OldChanges README README.mkdn
%doc --no-dereference LICENSE
%{perl_vendor_privlib}/HTML*

%changelog
