# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Test/Run/CmdLine/Iface.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    HTML-Links-Localize
%define upstream_version 0.2.11

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    Convert HTML Files to be used on a hard disk
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/HTML/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Copy.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(HTML/TokeParser.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
HTML::Links::Localize converts HTML files to be used when viewing on the
hard disk. Namely, it converts relative links to point to "index.html"
files in their directories.

To use it, first initialize an instance using new:

$converter = HTML::Links::Localize->new(base_dir => $base_dir, dest_dir =>
$dest_dir)
    The constructor accepts two named parameters which are mandatory.
    ''base_dir'' is the base directory (or source directory) for the
    operations. ''dest_dir'' is the root destination directory.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc COPYING Changes LICENSE META.json META.yml  README examples
%{_bindir}/html-to-hd
%{_mandir}/man1/*
%perl_vendor_privlib/*

%changelog
