# BEGIN SourceDeps(oneline):
BuildRequires: perl(CHI.pm) perl(Carp.pm) perl(Config/Auto.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(File/Temp.pm) perl(HTTP/Response.pm) perl(JSON/MaybeXS.pm) perl(LWP/UserAgent.pm) perl(Scalar/Util.pm) perl(Test/Compile.pm) perl(Test/DescribeMe.pm) perl(Test/HTML/Lint.pm) perl(Test/HTTPStatus.pm) perl(Test/JSON.pm) perl(Test/MockObject.pm) perl(Test/Most.pm) perl(Test/Needs.pm) perl(Test/RequiresInternet.pm) perl(Test/Warnings.pm) perl(Time/HiRes.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name HTML-OSM
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: A module to generate an interactive OpenStreetMap with customizable coordinates and zoom level.
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`HTML::OSM' is a Perl module for generating an interactive map using OpenStreetMap (OSM) and Leaflet.
The module accepts a list of coordinates with optional labels and zoom level to create a dynamic HTML file containing an interactive map.
The generated map allows users to view marked locations, zoom, and search for locations using the Nominatim API.

    use HTML::OSM;
    my $map = HTML::OSM->new();
    # ...

    $map = HTML::OSM->new(
_coordinates => [
_  [34.0522, -118.2437, 'Los Angeles'],
_  [undef, undef, 'Paris'],
_],
_zoom => 14,
    );
    my ($head, $map_div) = $map->onload_render();

=over 4

=item * Caching

Identical geocode requests are cached (using the CHI manpage or a user-supplied caching object),
reducing the number of HTTP requests to the API and speeding up repeated queries.

This module leverages the CHI manpage for caching geocoding responses.
When a geocode request is made,
a cache key is constructed from the request.
If a cached response exists,
it is returned immediately,
avoiding unnecessary API calls.

=item * Rate-Limiting

A minimum interval between successive API calls can be enforced to ensure that the API is not overwhelmed and to comply with any request throttling requirements.

Rate-limiting is implemented using the Time::HiRes manpage.
A minimum interval between API
calls can be specified via the `min_interval' parameter in the constructor.
Before making an API call,
the module checks how much time has elapsed since the
last request and,
if necessary,
sleeps for the remaining time.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE examples
%perl_vendor_privlib/H*

%changelog
