# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/SHA.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(HTML/Parser.pm) perl(IO/File.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(overload.pm) unzip
# END SourceDeps(oneline)
%define module_name HTML-Persistent
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Perl database aimed at storing HTML tree structures.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TT/TTNDY/%{module_name}-%{version}.zip
BuildArch: noarch

%description
This provides an interface that provides convenient access to data with a syntax that is mostly comfortable
for perl users. It uses the overload and tie trick to allow both array and hash references to be acceptable
in arbitrary mix, and allows a mild language ambiguity to assign values to nodes as well as visiting new nodes.

For example, assigning a sub-node to a variable creates the necessary sub-node (if it does not already exist),
but evaluating the same in a string context will reveal the data value contained in the sub-node (or undef if
it does not exist). Evaluating in a numeric context also returns undef if the node does not exist, but forces
the string into a number if a data-value can be found (following normal perl rules).

The database should be concurrent (i.e. multiple processes can safely open the same database) but regular calls
to sync() are required since locking is only released on a sync() call, judging how often to run the sync() is
a matter for the application but it will usually be a somewhat expensive call (in the background using perl
Storable which decomposes the objects into bytecodes and writes at least one entire file). Some granularity factors
are tunable (e.g. largest whole file before splitting it down into directories and smaller files) and these may
effect the optimal sync() placement. In addition, the sync() may be seen as a transaction boundary, but the only
rollback feature is just throwing away the $db object and starting a new object (which is reasonably cheap to do).

The general intention is for medium to long lived server processes to call sync() when they are waiting for
more work (e.g. waiting for a web request) and to try to atomically complete whole requests. Also, it is generally
intended to be faster in a read-only situation (shared locks) than a read/write situation (exclusive locks).
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/H*

%changelog
