%define module_name HTML-SocialMeta
Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Coerce/Types/Standard.pm) perl(ExtUtils/MakeMaker.pm) perl(List/MoreUtils.pm) perl(Moo.pm) perl(MooX/LazierAttributes.pm) perl(MooX/ValidateSubs.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Type/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.74007
Release: alt1
Summary: Module to generate Social Media Meta Tags, 
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LN/LNATION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module generates social meta tags.

i.e  $social->create('summary') will generate:
    
    <meta name="twitter:card" content="summary"/>
    <meta name="twitter:site" content="@example_twitter"/>
    <meta name="twitter:title" content="You can have any title you wish here"/>
    <meta name="twitter:description" content="Description goes here may have to do a little validation"/>
    <meta name="twitter:image" content="www.urltoimage.com/blah.jpg"/>
    <meta property="og:type" content="thumbnail"/>
    <meta property="og:title" content="You can have any title you wish here"/>
    <meta property="og:description" content="Description goes here may have to do a little validation"/>
    <meta property="og:url" content="www.someurl.com"/>
    <meta property="og:image" content="www.urltoimage.com/blah.jpg"/>
    <meta property="og:site_name" content="Example Site, anything"/>
    <meta property="fb:app_id" content="123433223543"/>'

It allows you to optimize sharing on several social media platforms such as Twitter, Facebook, Google+ 
and Pinerest by defining exactly how titles, descriptions, images and more appear in social streams.

It generates all the required META data for the following Providers:

    * Twitter
    * OpenGraph

This module currently allows you to generate the following meta cards:

    $social->create()  $twitter->create_       $opengraph->create_  _
    summary            summary                 thumbnail         _
    featured_image     summary_large_image     article            _ 
    player             player                  video              _
    app                app                     product
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README README.md
%perl_vendor_privlib/H*

%changelog
