Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Test/Kwalitee.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perform optional tests
%bcond_with perl_HTML_Strip_enables_optional_test

Name:           perl-HTML-Strip
Version:        2.12
Release:        alt2_11
Summary:        Perl extension for stripping HTML markup from text
License:        GPL-1.0-or-later OR Artistic-1.0-Perl

URL:            https://metacpan.org/release/HTML-Strip
Source0:        https://cpan.metacpan.org/authors/id/K/KI/KILINRAX/HTML-Strip-%{version}.tar.gz

BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(DynaLoader.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Optional run-time:
BuildRequires:  perl(HTML/Entities.pm)
# Tests:
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(Test/Exception.pm)
# Test::Kwalitee not used
BuildRequires:  perl(Test/More.pm)
%if %{with perl_HTML_Strip_enables_optional_test}
# Optional tests
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
%endif
Requires:       perl(HTML/Entities.pm)


Source44: import.info

%description
This module simply strips HTML-like markup from text in a very quick and
brutal manner. It could quite easily be used to strip XML or SGML from text
as well; but removing HTML markup is a much more common problem, hence this
module lives in the HTML:: namespace.

%prep
%setup -q -n HTML-Strip-%{version}


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
unset RELEASE_TESTING
%{make_build} test

%files
%doc Changes README
%{perl_vendor_archlib}/auto/HTML*
%{perl_vendor_archlib}/HTML*

%changelog
