# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN/Meta.pm) perl(Module/Metadata.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    HTML-TableContentParser
%define upstream_version 0.305

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    Do interesting things with the contents of tables
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/HTML/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(HTML/Parser.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This package pulls out the contents of a table from a string containing
HTML. Each time a table is encountered, data will be stored in an array
consisting of a hash of whatever was discovered about the table -- id,
name, border, cell spacing, etc., and of course data contained within the
table.

The format of each hash will look something like

  attributes            keys from the attributes of the <table> tag
  @{$table_headers}     array of table headers, in order found
  @{$table_rows}        rows discovered, in order

%prep
%setup -q -n %{upstream_name}-%{upstream_version}


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%__make test

%install
%makeinstall_std

%files
%doc Changes LICENSES META.json META.yml  README TODO
%perl_vendor_privlib/*


%changelog
