# BEGIN SourceDeps(oneline):
BuildRequires: perl(Test/More.pm) perl(HTML/PullParser.pm) perl(IO/Util.pm)
# END SourceDeps(oneline)
%define module_version 1.21
%define module_name HTML-TableTiler
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.21
Release: alt1
Summary: easily generates complex graphic styled HTML tables
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DO/DOMIZIO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
HTML::TableTiler uses a minimum HTML table as a tile to generate a complete HTML table from a bidimensional array of data. It can easily produce simple or complex graphic styled tables with minimum effort and maximum speed..
Think about the table tile as a sort of tile that automatically expands itself to contain the whole data. You can control the final look of a table by choosing either the HORIZONTAL and the VERTICAL tiling mode among: PULL, TILE and TRIM.

The main advantages to use it are:

=over

=item * automatic table generation

Pass only a bidimensional array of data to generate a complete HTML table. No worry to decide in advance the quantity of cells (or rows) in the table.

=item * complex graphic patterns generation without coding

Just prepare a simple table tile in your preferred WYSIWYG HTML editor and let the module do the job for you.

=item * simple to maintain

You can indipendently change the table tile or the code, and everything will go as you would expect.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/H*

%changelog
