# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Class/Accessor/Fast.pm) perl(Class/C3.pm) perl(Class/Inspector.pm) perl(Config.pm) perl(Cwd.pm) perl(DirHandle.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Template.pm) perl(Test/More.pm) perl(UNIVERSAL/isa.pm) perl(UNIVERSAL/require.pm) perl(YAML.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name HTML-TagClouder
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Configurable Tag Cloud Generator
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DM/DMAKI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
*WARNING* Alpha software! I mean it!

HTML::TagClouder is another take on generating Tagclouds.

It was build because a coleague complained that he wanted to customize the
HTML that gets generated for tag clouds. Other modules generated their
own HTML and it was hardcoded, hence HTML::TagClouder was born.

Currently it does just the bare minimum to generate a cloud (see CAVEATS),
but the entire process is completely configurable by allowing you to pass
in class names to do the particular job in each phase of generating the
tag cloud.

HTML::TagClouder goes through 3 phases before generating a tag cloud:

=over 4

=item 1. Data Collection

Build up your tag list via $cloud->add($tag). The tag collection is built
using HTML::TagClouder::Collection.

=item 2. Process The Tags

The processor specified in processor_class (HTML::TagClouder::Processor::Simple
by default) will iterator through the collection that was built, and will
do any required calculation.

=item 3. Render The Tags

The tags will be rendered as appropriate. By default we use Template Toolkit
for this via HTML::TagClouder::Render::TT.

=back

The main difference between the other tag cloud generators is that each
phase of the cloud generation is completely configurable. For example, by
default it uses a very naive algorithm to calculate the font sizes for
the tags, but you can easily change the logic by simple changing the
'processor' class to something you built:

  my $cloud = HTML::TagClouder->new(
    processor_class => 'MyProcessor'
  );

Or, should you decide to use a different rendering engine than the default
Template Toolkit based renderer, you can do:

  my $cloud = HTML::TagClouder->new(
    render_class => 'MyRenderClass'
  );


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes examples
%perl_vendor_privlib/H*

%changelog
