# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test.pm)
# END SourceDeps(oneline)
%define module_version 1.01
%define module_name HTML-Template-Filter-Dreamweaver
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: a module that provides a filter function to translate
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BP/BPAULSEN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module will translate Dreamweaver MX templates into a form understood HTML::Template.
 This used to be the old documentation...
 For the most part this module should work exactly how you expect it should.  There are a few
 features in this module that Dreamweaver designers should know about.

 As you might expect, I got a few requests for something more descriptive.  Here is a second try.
 
 Dreamweaver MX has updated their templating code fairly heavily, and 
 now it supports many of the things that HTML::Template does.
 
 For example, you can define template variables, repeating sections, use 
 conditional logic, etc.  I'll try to give a quick summation here, but 
 in all honesty, you would do better by browsing Macromedia's website, 
 downloading the trial version. or buying a book on it.
 
 Dreamweaver allows you to set up a template file (it ends in an 
 extension called .dwt).  You can then use this template to create HTML 
 files where you change the pre-defined parameters of the template.
 
 Some examples:
 Dreamweaver MX prefers that all variables in the template be named at 
 the top of the .dwt HTML.  This is done by using the <!-- TemplateParam 
 --> tag.  You can define a default for the parameters and you also 
 define the type of variable (e.g. boolean, text, number, etc.)
 
 In the HTML of the template, you can then use your variables in syntax 
 like <!-- TemplateExpr expr="foo" --> or @@(foo)@@.  This is analagous 
 to the <TMPL_VAR> syntax of HTML::Template
 
 Another Dreamweaver tag is the <!-- TemplateBeginIf --> and <!-- 
 TemplateEndIf --> tags.  These are similar to the <TMPL_IF> and 
 </TMPL_IF> tags.
 
 Also, there are <!-- TemplateBeginRepeat --> and <!-- TemplateEndRepeat 
 --> tags.  As you can guess, these are similar to the <TMPL_LOOP> and 
 </TMPL_LOOP> tags.
 
 There's also a few more tags, but as you can see Dreamweaver MX 
 supports syntax very similar to HTML::Template.
 
 Finally, for seeing what the page would look like when you populate the 
 variables, Dreamweaver allows you to create an HTML page using the 
 template as a starting point.  Under the "Modify" menu, there is a 
 choice that says "Template Properties".  In there, you can set 
 variables to whatever you like.  This is very similar to the param 
 function of HTML::Template.
 
 Personally, I think Dreamweaver MX is so close to HTML::Template that 
 it's possible for an HTML designer to use it and create great mockups 
 of pages.  After developing the mockup, he can give the template to an 
 HTML::Template user who can then combine it with his code to 
 dynamically fill in the template variables.
 
 So, the package that I provided should create be an excellent transform 
 function for converting Dreamweaver template files into HTML::Template 
 files.

=over 4

=item *
 Escaping.  HTML::Template allows variables to be HTML escaped or URL escaped.  I do not know
 how to specify this in Dreamweaver, so I invented a syntax.  

 In the <!-- TemplateParam --> section, you can specify an escaping scheme that you would like
 to use.  For example, <!-- TemplateParam name="foo" type="text" value="yes & no" escape="HTML" -->
 would mean that the "foo" variable would be HTML escaped whenever it is used.

 If you wish to override the escaping scheme provided by the <!-- TemplateParam --> section,
 you can do this in the <!-- TemplateExpr --> section.  For example, to get URL escaping, do
 the following:  <!-- TemplateExpr expr="foo" escape="HTML" -->

 An alternative syntax would be the following @@(_document._Get( "foo", "HTML" ))@@


=item *
 The filter should be able to translate Dreamweaver templates into something that could be
 understood by HTML::Template::Expr.  However, it will only attempt to do this if the filter
 is being used from within HTML::Template::Expr.  It does this by looking at the caller stack.
 If for some reason this is not working correctly, you can force the filter to convert into
 HTML::Template::Expr syntax by using the function DWT2HTMLExpr


=item *
 While we are on the Expr subject...  I believe it will work in most cases.  Just remember that
 this is a fairly dumb filter.  It will translate things like '==' to ' eq ' for text strings,
 but that is about it.  In other words, there are some warnings about how expressions should
 be written within the HTML::Template::Expr documentation.  Heed those warnings, because this
 filter will not fix the problems for you.


=item *
 Dreamweaver supports ternary logic (i.e, foo > 5 ? "yes" : "no" ), but HTML::Template::Expr
 does not.  I put in a very basic test to try to convert these into IF-ELSE clauses.


=item *
 HTML::Template allows you to not put quotes around variables and words.  For example, you could
 say <TMPL_VAR NAME=foo ESCAPE=HTML>.  DWT2HTML is not so nice.  It expects quotes (either single
 or double) around those things.  I believe that Dreamweaver also requires the same, so this 
 should not be an issue unless you are hand editing code.

=back


%prep
%setup -n Dreamweaver

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/H*
%perl_vendor_privlib/auto/*
%changelog
