%define module_name HTML-Template-Nest
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(HTML/Template.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: manipulate a nested html template structure via a perl hash
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOMGRACEY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
HTML::Template is great because it is simple, and doesn't violate MVC in the uncomfortable way Mason does. However if you want components you can manipulate easily and nest arbitrarily, then the raw interface can be labour intensive to work with. For example, to recreate the example in the synopsis using plain HTML::Template, you would need to do something like:

    # first create and populate the inner templates
    my $box1 = HTML::Template->new( filename => 'box.html' ); 
    $box1->param( title => 'First nested box' );
    my $box2 = HTML::Template->new( filename => 'box.html' );
    $box2->param( title => 'Second nested box' );

    # feed the output to the contents of the parent
    my $page = HTML::Template->new( filename => 'page.html' );
    $page->param( contents => $box1->output.$box2->output );

    print $page->output;


It's easy to see how this quickly becomes inconvenient as the size of the component structure increases. It would be better if a routine could create and fill in the params recursively - and this is where HTML::Template::Nest comes in.


Nest uses HTML::Template to create whatever nested structure of templates you give it. Nest

- accepts the input structure as a hashref
- with each (sub)component as a hashref, 
- and each list of components as an arrayref

ie. the components are represented in terms of the most obvious basic perl datatypes, which means you are free to form your structure in any of the many ways you can manipulate normal hashes/arrays. This ends up being a surprisingly powerful templating system with some great advantages - the most obvious being true separation of controller from view. E.g. lets say you wanted to create a 2 row 2 column table using the following templates:

    table.html:
    <table>
        <!-- TMPL_VAR NAME=rows -->
    </table>

    row.html:
    <tr>
        <!-- TMPL_VAR NAME=columns -->
    </tr>


    column.html 
    <td>
        <!-- TMPL_VAR NAME=value -->
    </td>


If you were feeling masochistic, you could do this:

    my $...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/H*

%changelog
