# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IO/String.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.2
%define module_name HTML-XHTML-DVSM
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2
Release: alt1
Summary: Dynamic Visual Software Modelling, XML/XHTML template system that does not screw up your templates....
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DV/DVSM/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
=over 4

=item The HTML - getstarted.html 

Illustrates all but one of the the DVSM commands that can be 
embedded into xml or xhtml markup, and the missing one is explained below.   
All markup must be xhtml not html.

    <html>
    <head>
    <title>Getting Started with HTML::XHTML::DVS1
    </head>
    <body>
    <h1>Getting Started with HTML::XHTML::DVS1
    This html markup illustrated the script commands available in HTML::XHTML::DVS1
    run printheader has output the header<br/>
    <h2>RU1
    run dorun will output "doRun called 1 times"<Br/>
    <span id="sid">hello world</span><br/>
    run dorun will output "doRun called 2 times"<br/>
    <span id="sid2">hello world</span>
    <!--DVSM
    run "printHeader"
    run "doRun()" where id = "sid"
    run "doRun()" where id = "sid2"
    -->
    <!--DSUBS
    sub printHeader { print "Content-type: text/html\n\n"; }
    my $count = 0;
    sub doRun {
        ++$count;
        print "doRun called $count times<br/>\n";
    }
    -->
    <h2>SE1
    textnode is set from hello world to hello sid<br/>
    <span id="set">hello world</span><br/>
    value of input is set to "set by set"<br/>
    <input type="text" value="" name="set2">
    <!--DVSM
    set textnode to "sayHello()" where id = "set"
    set value to "return 'set by set';" where name = "set2"
    -->
    <!--DSUBS
    sub sayHello {
        return "hello sid";
    }
    -->
    <h2>TOGGLE</h2>
    Current value set to Option 2 by TOGGLE command<br/>
    <select name="myselect">
    <option value="1" select="myselect">Option 1</option>
    <option value="2" select="myselect">Option 2</option>
    <option value="3" select="myselect">Otpion 3</option>
    </select><br/>
    <!--DVSM
    toggle selected to "doToggle()" where select = "myselect"
    -->
    <!--DSUBS
    my $selected = 2;
    sub doToggle {
        my $sb = getSB();
        my $value = $sb->sbGetCurrentTagValue( "value" );
        return ( $value eq $selected );
    }
    -->
    <h2>DELETE</h2>
    Option 2 and Option 3 removed by DELETE command<br/>
    <select name="myselect">
    <option value="1" select="myselect">Option 1</option>
    <option value="2" select="deleteme">Option 2</option>
    <option value="3" select="deleteme">Otpion 3</option>
    </select>
    <!--DVSM
    delete where select = "deleteme"
    -->
    <h2>WHILE</h2>
    WHILE command is used to populate the table with a data set of customers:
    148842 => "Mr J Smith", 848488 => "Ms S Jones", 484848 => "Mrs P Cook", 982828 => "Joe Bloggs"
    <table>
    <tr><th>Customer Number</th><th>Customer Name</th></tr>
    <tbody>
    <tr name="customers"><td name="custid">12345</td><td name="custname">Mr Bloggs</td></tr>
    <tr name="deleteme"><td>23456</td><td>Mrs Soap</td></tr>
    <tr name="deleteme"><td>67890</td><td>Mr A N Other</td></tr>
    </tbody>
    </table>
    <!--DVSM
    delete where name = "deleteme"
    while "moreCustomers()" where name = "customers"
       set textnode to "getCustid()" where name = "custid"
       set textnode to "getCustname()" where name = "custname"
    end while
    -->
    <!--DSUBS
    my %%db = ( 148842 => "Mr J Smith", 848488 => "Ms S Jones", 484848 => "Mrs P Cook", 982828 => "Joe Bloggs" );
    my $cursor = -1;
    sub moreCustomers {
        $cursor++;
        my @keys = keys( %%db );
        return ( $cursor < @keys );
    }
    sub getCustid {
        my @keys = sort keys( %%db );
        return $keys[$cursor];
    }
    sub getCustname {
        return $db{getCustid()};
    }
    -->
    <h2>I/h2
    <p>This paragraph always happens</p>
    <p id="datepara_even">This paragraph only happens if the date of the month
    (<span id="thedate"></span>) is an even number</p>
    <p id="datepara_odd">This version of the paragraph only happens if the date of the month
    (<span id="thedate"></span>) is an odd number</p>
    <!--DVSM
    if "dateiseven()" where id = "datepara_even"
       set textnode to "getdate()" where id = "thedate"
    end if
    if "dateisodd()" where id = "datepara_odd"
       set textnode to "getdate()" where id="thedate"
    end if
    -->
    <!--DSUBS
    sub dateisodd { return ( ! dateiseven() ); }
    sub dateiseven {
        my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
            localtime(time);
        return ( $mday %% 2 == 0 );
    }
    sub getdate {
        my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
            localtime(time);
        return sprintf( "%%.2d/%%.2d/%%.4d", $mday, $mon + 1, 1900 + $year );
    }
    -->
    </body>
    </html>

The one DVSM script command not shown here is: `<!--DVSM_include file/path.html-->' 
which allows you to load a snippet of markup into the main document at the point of the
include directive.  The snippet can contain DVSM script and DSUBS perl sections.

=item The perl script - getstarted.pl

Shows how to use HTML::XHTML::DVSM to animate getstarted.html

    #!/usr/bin/perl -w
    package sb_getstarted;
    use HTML::XHTML::DVSM;
    my $scriptdir = "."; #may have to change this for mod_perl
    my $htmldir = "$scriptdir";
    our $sb; #for mod_perl
    sub getSB { return $sb; }
    $sb = HTML::XHTML::DVSM->new( SCRIPT_TAG => "DVSM", SUBS_TAG => "DSUBS" ) if ( ! $sb );
    $sb->sbInit();
    #$sb->sbClearCache(); #can be used if modify html and using mod_perl
    $sb->sbSetEvalPackage( "sb_getstarted" ); #when running code in getstarted.html this is the package name
    $sb->sbSetStopOnError( 1 );
    eval {
        $sb->sbInitPage( "", "$htmldir", "getstarted.html", "" );
        $sb->sbPrintDocument();
    };
    if ( $@ ) {
        print "Content-type: text/plain\n\n";
        print "ERROR: $@";
    }

=item Instructions

Put both getstarted.html and getstarted.pl in the same directory.  
cd to that directory.

Run:

    perl getstarted.pl
    
and view the output. 

Once you have viewed the output try putting both files in your cgi-bin directory.  Then run the demo
by loading the getstarted.pl url in your browser: e.g. http://localhost/cgi-bin/getstarted.pl.
Make sure getstarted.pl has execute permissions and that `#!/usr/bin/perl' is the correct
path for perl - you may have to change this shell directive to give the correct path.

Notice that getstarted.html is good html that any browser can load.  The html before transformation
is not corrupted by the DVSM instructions, unlike almost all other html template systems.

=back


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/H*

%changelog
