# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Sys/HostIP.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    HTTP-Async
%define upstream_version 0.33

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Politely process multiple HTTP requests
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/HTTP/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(HTTP/Cookies.pm)
BuildRequires: perl(HTTP/Request.pm)
BuildRequires: perl(HTTP/Response.pm)
BuildRequires: perl(HTTP/Server/Simple/CGI.pm)
BuildRequires: perl(HTTP/Status.pm)
BuildRequires: perl(IO/Select.pm)
BuildRequires: perl(LWP/UserAgent.pm)
BuildRequires: perl(Net/EmptyPort.pm)
BuildRequires: perl(Net/HTTP.pm)
BuildRequires: perl(Net/HTTP/NB.pm)
BuildRequires: perl(Net/HTTPS/NB.pm)
BuildRequires: perl(Test/Fatal.pm)
BuildRequires: perl(Test/HTTP/Server/Simple.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Time/HiRes.pm)
BuildRequires: perl(URI.pm)
BuildRequires: perl(URI/Escape.pm)
BuildArch:  noarch
Source44: import.info

%description
Although using the conventional 'LWP::UserAgent' is fast and easy it does
have some drawbacks - the code execution blocks until the request has been
completed and it is only possible to process one request at a time.
'HTTP::Async' attempts to address these limitations.

It gives you a 'Async' object that you can add requests to, and then get
the requests off as they finish. The actual sending and receiving of the
requests is abstracted. As soon as you add a request it is transmitted, if
there are too many requests in progress at the moment they are queued.
There is no concept of starting or stopping - it runs continuously.

Whilst it is waiting to receive data it returns control to the code that
called it meaning that you can carry out processing whilst fetching data
from the network. All without forking or threading - it is actually done
using 'select' lists.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  TODO
%{perl_vendor_privlib}/*


%changelog
