Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Parser.pm) perl(Pod/Usage.pm) perl-podlators
# END SourceDeps(oneline)
BuildRequires: perl(Term/ReadLine.pm)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-HTTP-DAV
Version:        0.50
Release:        alt1_3
Summary:        WebDAV client library for Perl5
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/HTTP-DAV
Source0:        https://cpan.metacpan.org/authors/id/C/CO/COSIMO/HTTP-DAV-%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Runtime
# XXX: BuildRequires:  perl(AutoLoader)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Glob.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(FileHandle.pm)
# XXX: BuildRequires:  perl(Getopt::Long)
BuildRequires:  perl(HTTP/Date.pm)
BuildRequires:  perl(HTTP/Headers.pm)
BuildRequires:  perl(HTTP/Request.pm)
BuildRequires:  perl(HTTP/Response.pm)
BuildRequires:  perl(LWP.pm)
# XXX: BuildRequires:  perl(Pod::Parser)
# XXX: BuildRequires:  perl(Pod::Usage)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(strict.pm)
# XXX: BuildRequires:  perl(Term::ReadLine)
# XXX: BuildRequires:  perl(Text::ParseWords)
BuildRequires:  perl(Time/Local.pm)
BuildRequires:  perl(URI.pm)
BuildRequires:  perl(URI/Escape.pm)
BuildRequires:  perl(URI/file.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XML/DOM.pm)
# Tests only
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Test.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(HTTP/Headers.pm)
Requires:       perl(LWP.pm) >= 5.480


Source44: import.info
%filter_from_requires /^perl(LWP.pm)/d

%description
HTTP::DAV is a Perl API for interacting with and modifying content on
web servers using the WebDAV protocol. Now you can LOCK, DELETE and PUT
files and much more on a DAV-enabled web server.

%prep
%setup -q -n HTTP-DAV-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
# %{_fixperms} %{buildroot}

%check
PERLDAV_TEST=default make test

%files
%doc Changes README TODO
%{_bindir}/dave
%{perl_vendor_privlib}/*
%{_mandir}/man1/*

%changelog
