%define module_name HTTP-Request-Webpush
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Crypt/AuthEnc/GCM.pm) perl(Crypt/JWT.pm) perl(Crypt/PK/ECC.pm) perl(Crypt/PRNG.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(MIME/Base64.pm) perl(URI.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.15
Release: alt1
Summary: HTTP Request for web push notifications
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ES/ESTRELOW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`HTTP::Request::Webpush' produces an HTTP::Request for Application-side Webpush
notifications as described on RFC8291.
In this scheme, an Application is a 
server-side component that sends push notification to previously subscribed
browser worker(s). This class only covers the Application role. A lot must 
be done on the browser side to setup a full working push notification system.

In practical terms, this class is a glue for all the encryption steps involved
in setting up a RFC8291 message, along with the <RFC8292|https://tools.ietf.org/html/rfc8291> VAPID scheme.

=over 4

=item $r=HTTP::Request::Webpush->new()

=item $r=HTTP::Request::Webpush-new(auth => $my_key, subscription => $my_subs, content='New lager batch arrived')

The following options can be supplied in the constructor: subscription, auth, reuseecc, subject, content.

=item $r->subscription($hash_reference)

=item $r->subscription('{"endpoint":"https://foo/fooer","expirationTime":null,"keys":{"p256dh":"BCNS...","auth":"dZ..."}}');

This sets the subscription object related to this notification service. This should be the same object
returned inside the browser environment using the PushManager.subscribe() method. The argument can
be either a JSON string or a previously setup hash reference.

=item $r->auth($pk) #pk being a Crypt::PK::ECC ref

=item $r->auth($pub_bin, $priv_bin)

=item $r->authbase64('BCAI00zPAbxEVU5w8D1kZXVs2Ro--FmpQNMOd0S0w1_5naTLZTGTYNqIt7d97c2mUDstAWOCXkNKecqgS4jARA8','M6xy5prDBhJNlOGnOkMekyAQnQSWKuJj1cD06SUQTow')

This sets the authentication key for the VAPID authentication scheme related to this push service.
This can either be a (public, private) pair or an already setup Crypt::PK::ECC object. The public part
must be the same used earlier in the browser environment in the PushManager.subscribe() applicationServerKey option.
The key pair can be passed as URL safe base64 strings using the authbase64() variant.

=item $r->reuseecc($ecc) #ecc being a Crypt::PK::ECC ref

By default,...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE examples
%perl_vendor_privlib/H*

%changelog
