%define module_name HTTP-Upload-FlowJs
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(Filter/signatures.pm) perl(JSON.pm) perl(MIME/Detect.pm) perl(Pod/Markdown.pm) perl(Pod/Readme.pm) perl(Test/More.pm) perl(Text/CleanFragment.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: handle resumable multi-part HTTP uploads with flowjs
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CO/CORION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This synopsis assumes a the Plack manpage/the PSGI manpage-like environment. There are
plugins for the Dancer manpage and the Mojolicious manpage planned. See
the HTTP::Upload::FlowJs::Examples manpage for longer examples.

The `flow.js' workflow assumes that your application handles two kinds of
requests, POST requests for storing the payload data and GET requests for
retrieving information about uploaded parts. You will have to make various calls
to the HTTP::Upload::FlowJs object to validate the incoming request at every
stage.

  use HTTP::Upload::FlowJs;

  my $uploads = '/tmp/flowjs_uploads/';
  my $flowjs = HTTP::Upload::FlowJs->new(
      incomingDirectory => $uploads,
      allowedContentType => sub { $_[0] =~ m!^image/! },
  );

  my @parameter_names = $flowjs->parameter_names();

  # In your POST handler for /upload:
  sub POST_upload {
    my $params = params();

    my %%info;
    @info{ @parameter_names } = @{$params}{@parameter_names};
    $info{ localChunkSize } = -s $params{ file };
    # or however you get the size of the uploaded chunk

    # you might want to set this so users don't clobber each others upload
    my $session_id = '';
    my @invalid = $flowjs->validateRequest( 'POST', \%%info, $session_id );
    if( @invalid ) {
        warn 'Invalid flow.js upload request:';
        warn $_ for @invalid;
        return [500,[],["Invalid request"]];
        return;
    };

    if( $flowjs->disallowedContentType( \%%info, $session_id )) {
        # We can determine the content type, and it's not an image
        return [415,[],["File type disallowed"]];
    };

    my $chunkname = $flowjs->chunkName( \%%info, undef );

    # Save or copy the uploaded file
    upload('file')->copy_to($chunkname);

    # Now check if we have received all chunks of the file
    if( $flowjs->uploadComplete( \%%info, undef )) {
        # Combine all chunks to final name

        my $digest = Digest::SHA256->new();

        my( $content_type, $ext ) = $flowjs->sniffContentType();
        my $final_name = "file1.$e...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.mkdn example
%perl_vendor_privlib/H*

%changelog
