# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Ham-WSJTX-Logparse
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Parses ALL.TXT log files from Joe Taylor K1JT's WSJT-X, to extract CQ and calling station informati...
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DE/DEVZENDO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Extract all log entries for a given band:

    use Ham::WSJTX::Logparse;

    my $log = Ham::WSJTX::Logparse->new();
    # Looks in the default location for the ALL.TXT file
    # or...
    my $log = Ham::WSJTX::Logparse->new("/path/to/an/ALL.TXT");
    # or, can parse multiple logs...
    my $log = Ham::WSJTX::Logparse->new("/tmp/ALL.TXT.one", "/tmp/ALL.TXT.two"); # etc., etc....
    ...

    # Define a callback

    my $callback = sub {
       my $date = shift;
       my $time = shift;
       my $power = shift;
       my $offset = shift;
       my $mode = shift;
       my $callsign = shift;
       my $grid = shift;
       print "date $date time $time power $power offset $offset mode $mode callsign $callsign grid $grid\n";
       # sure you can do something interesting with this!
    };

    $log->parseForBand("20m", $callback);
    # many entries are printed....
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/H*

%changelog
