# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(Ham/Locator.pm) perl(Imager.pm) perl(Math/Trig.pm) perl(POSIX.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Ham-WorldMap
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Creates an Imager image containing an equirectangular projection of the world map, with optional Ma...
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DE/DEVZENDO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
To create a map with a station location, grid squares, and night/day boundary:

    use Ham::WorldMap;

    # By default, an OSX-specific font will be used for drawing text. If you're not on OSX, supply the name of a
    # font file...
    my $map = Ham::WorldMap->new();  # fine on OSX, uses Lucida Console.
    my $map = Ham::WorldMap->new('fontFile' => "C:\\Windows\\Fonts\\Arial.ttf");  # Windows, not tested.

    # The map now has the world on it.

    my $colour = Imager::Color->new(16, 16, 192);
    my $radius = 20;
    $map->dotAtLocator("JO01EE", $radius, $colour); # M0CUV is here!

    # World plus dot.

    my $dt = DateTime->new(
        year       => 2016,
        month      => 6,
        day        => 5,
        hour       => 0,
        minute     => 0,
        second     => 0,
        nanosecond => 0,
        time_zone  => 'UTC',
    );
    $map->drawNightRegions($dt);

    # The world plus dot, with day/night on top.

    $map->drawLocatorGrid();

    # The grid is on top of the world/dot/day/night.

    $map->write("map.png");
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE.txt
%perl_vendor_privlib/H*
%perl_vendor_privlib/auto/*

%changelog
