Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Hardware-Vhdl-Lexer
Version:        1.00
Release:        alt2_48
Summary:        Split VHDL code into lexical tokens
License:        GPL-1.0-or-later OR Artistic-1.0-Perl

URL:            https://metacpan.org/release/Hardware-Vhdl-Lexer
Source0:        https://cpan.metacpan.org/authors/id/M/MY/MYKL/Hardware-Vhdl-Lexer-%{version}.tar.gz

BuildArch:      noarch

BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Class/Std.pm)
BuildRequires:  perl(Readonly.pm)
# Tests
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)

Requires:       perl(Readonly.pm) >= 1.030

# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(Readonly.pm)/d

%description
Hardware::Vhdl::Lexer splits VHDL code into lexical tokens. To use it, you
need to first create a lexer object, passing in something which will supply
chunks of VHDL code to the lexer. Repeated calls to the get_next_token
method of the lexer will then return VHDL tokens (in scalar context) or a
token type code and the token (in list context). get_next_token returns
undef when there are no more tokens to be read.


%prep
%setup -q -n Hardware-Vhdl-Lexer-%{version}

# rpmlint : line endings spurious-executable-perm
for i in Changes README lib/Hardware/Vhdl/Lexer.pm ; do
  echo "Fixing wrong-file-end-of-line-encoding : $i"
  sed 's/\r//' $i > $i.rpmlint
  touch -r $i $i.rpmlint;
  mv $i.rpmlint $i
  echo "Fixing perms : $i"
  chmod 0644 $i
done

# workaround for bug in rpmbuild
# disables the Requires of modules in commented code
sed "s|use regexp-generating|#use regexp-generating|" \
  lib/Hardware/Vhdl/Lexer.pm > Lexer.pm
touch -r lib/Hardware/Vhdl/Lexer.pm Lexer.pm;
mv Lexer.pm lib/Hardware/Vhdl/Lexer.pm

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build


%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*


%check
make test


%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
