Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Hardware-Vhdl-Parser
Version:        0.12
Release:        alt2_48
Summary:        Complete grammar for parsing VHDL code using perl
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Hardware-Vhdl-Parser
Source0:        https://cpan.metacpan.org/authors/id/G/GS/GSLONDON/Hardware-Vhdl-Parser-%{version}.tar.gz
# rt#102452
Patch0:         Hardware-Vhdl-Parser-0.12-unreachable.patch
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Runtime
BuildRequires:  perl(Parse/RecDescent.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
Source44: import.info
# Tests only

%description
This module defines the complete grammar needed to parse any VHDL code. By
overloading this grammar, it is possible to easily create perl scripts
which run through VHDL code and perform specific functions.

%prep
%setup -q -n Hardware-Vhdl-Parser-%{version}
%patch0  -p1
find . -type f | xargs perl -pi -e 's|#!\s*/bin/perl|#!%{__perl}|'
# rt#102450
rm -rf Hardware

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
rm -f %{buildroot}%{perl_vendor_privlib}/Hardware/Vhdl/*.pl
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes readme.txt test1.vhd
%doc parser.pl hierarchy.pl
%{perl_vendor_privlib}/*

%changelog
