%define module_version 0.007
%define module_name Hash-DefaultValue
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(Tie/Hash.pm) perl(constant.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.007
Release: alt1
Summary: create a hash where the default value ain't undef
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Hash-DefaultValue

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Normally, if you try fetching a value from a hash where the key does
not exist, you get undef.

  my %%hash;
  if (defined $hash{foobar}) {
    say "this will not happen!";
  }

Hash::DefaultValue allows you to choose another value instead of
undef. It tried to avoid changing any other part of the hash's
behaviour. For example, it doesn't automatically create any hash
keys that Perl wouldn't normally autovivify.

  tie my %%hash, 'Hash::DefaultValue', 42;
  say $hash{the_answer};                    # says 42
  my $exists = exists $hash{the_answer};    # false
  say keys %%hash;                           # says nothing

And of course you can still store explicit values in the hash, as
you'd expect:

  tie my %%hash, 'Hash::DefaultValue', 42;
  $hash{monkey} = 'Bobo';
  say $hash{the_answer};     # says 42
  say $hash{monkey};         # says "Bobo"

Delete operations on the hash are vaguely interesting:

  tie my %%hash, 'Hash::DefaultValue', 42;
  $hash{monkey} = 'Bobo';
  my $the_answer = delete $hash{the_answer};  # undef
  my $monkey     = delete $hash{monkey};      # "Bobo"


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT README LICENSE Changes
%perl_vendor_privlib/H*

%changelog
