# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Hash-Iter
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Generate a coderef iterator for a hash
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Hash-Iter

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a simple iterator which is a coderef that you can call
repeatedly to get pairs of a hash/hashref. When the pairs are exhausted, the
coderef will return undef. No class/object involved.

The principle is very simple and you can do it yourself with:

 my $iter = do {
     my $hash = shift;
     my $i = 0;

     my @ary = keys %%$hash;
     sub {
         if ($i < @ary) {
             my $key = $ary[$i++];
             return ($key, $hash->{$key});
         } else {
             return undef;
         }
     };
  }

Caveat: if list/array contains an `undef' element, it cannot be distinguished
with an exhausted iterator.

=for Pod::Coverage .+

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/H*

%changelog
