%define module_name Hash-Lazy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/OPCheck.pm) perl(Module/Build/Tiny.pm) perl(Sub/Exporter.pm) perl(Test/More.pm) perl(Tie/Hash.pm) perl(self.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: A Hash implementation with lazy evaluation feature
Group: Development/Perl
License: mit
URL: https://github.com/gugod/Hash-Lazy

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GU/GUGOD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Hash::Lazy is a way to have a lazy evaluated hash in your
program. Unlike other `Hash::*' modules, it doesn't work on real hash
variables (those with %% sigil). Read on to see how it works.

This module exports a keyword `Hash' by default. If you cannot import
this keyword in your current namespace for any reasons, you can
re-named to 'lazy_hash' (or any other names or your choice) by saying:

    use Hash::Lazy Hash => { -as => 'lazy_hash' };

This `Hash' keyword construct and returns an object that acts exactly
like a normal hash reference. It requies a code block as its only
argument. The block will be the builder to build the value of the
wanted key. Therefore, the current hash object and the key will be the
block arguments. This block need to either returns the value, or sets
it back to `$hash'.

    # returns it
    $next = Hash {
        my ($hash, $key) = @_;
        return $key + 1;
    };

    # or assign it
    $next = Hash {
        my ($hash, $key) = @_;
        $hash->{$key} = $key + 1;
    };

The later takes advantages of the former if you do both.

The returned object is just like a hash reference, therefore it's safe to assign values to it, or clear it:

    # Clear all previously calculated values, and resets the seed.
    %%$fib = ();
    $fib->{0} = 1;
    $fib->{1} = 1;

Notice that it's not ok to copy it to a hash:

    %%fib = %%$fib;

This basically freeze the magic-ness and the resulting %%fib becomes
static. The builder will not be called through any access to the
%%fib hash. Please be aware of this if you intend to do so.

The example code of fibonacci number above are also available at
examples/fib.pl in the distribution tarball, or at
http://cpansearch.perl.org/src/GUGOD/Hash-Lazy-0.01/examples/fib.pl.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes examples
%perl_vendor_privlib/H*

%changelog
