%define module_name Hustle-Table
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Template/Plex.pm) perl(Test/More.pm) perl(constant/more.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.7.3
Release: alt1
Summary: Pattern dispatching to subroutines
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DR/DRCLAW/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module provides a small class to construct a dispatch table and build a
dispatcher for it. All interactions are done via the object/class methods so no
exports are defined.

It supports straightforward optimisation of the dispatch table and also utilises
a optional cache to squeeze even more performance out.

Notable features include:

 
=over 

=item *

Non exact (regexp) and exact (string) matching in the same table

=item *

Uses built-in Perl features  (regex, given/when, smart-match)

=item *

Captures in regex are available in dispatched subs

=item *

Arguments supplied to dispatcher are available to executed vector

=item *

Cached pre-matching (optional)

=item *

Basic hit count and optimising (optional)

=item *

Fall through/catch all matching

=back


The dispatch table is essentially a list of at least one entry which maps a
matcher to a subroutine to call on a successfully match of the input.

Conceptually the list is looped over, applying the matchers sequentially to the input until a
match is found. In practice it isn't a loop, but generated code reference with 
optimised ordering of the entries.

In the case of no successful match, a default catch all dispatch vector is called.
 
Matching performance is optionally boosted by using a hash as a cache. Hash
lookup is much quicker than repeated conditional testing. Controlling which
inputs are removed from the cached is dictated by the return value of the
dispatch vector/sub

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README README.md
%perl_vendor_privlib/H*

%changelog
