%define module_version 0.04
%define module_name IETF-ACE
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm) perl(Test/More.pm) perl(Unicode/String.pm) perl(diagnostics.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Perl extension for IETF IDN WG ACE character conversions
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JB/JBRIGGS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
IETF::ACE - Perl extension for IETF IDN WG ACE character conversions.
  Subroutines

  UCS4toName
  UCS4toUPlus
  UTF5toUCS4
  GetCharFromUTF5
  UCS4toRACE
  RACEtoUCS4
  UCS4toLACE
  LACEtoUCS4
  Base32Encode
  Base32Decode
  CheckForSTD13Name
  CheckForBadSurrogates
  HexOut
  DebugOn
  DebugOff
  DebugOut

  The formats are:

  utf8
  utf16
  ucs4
  utf5      from draft-jseng-utf5-01.txt
  race      draft-ietf-idn-race-03.txt
  lace      draft-ietf-idn-lace-01.txt
  name      The character names; output only
  u+        The character hex values in U+ notation; output only

Sample Program

 use strict;
 use diagnostics;

 use Unicode::String qw / utf8 /;
 use IETF::ACE qw / &UCS4toRACE /;

 my $TheIn="a.bcde"; # .com

 my $TheUCS4 = utf8($TheIn)->ucs4;

 my $TheOut = &UCS4toRACE($TheUCS4);

 print <<EOD;
Latin1 Input = $TheIn.com
RACE Output = $TheOut.com
EOD


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/I*
%perl_vendor_privlib/auto/*
%changelog
