%define module_version 0.02
%define module_name IMAP-Query
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(List/MoreUtils.pm) perl(Module/Build.pm) perl(Readonly.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Build IMAP search queries!
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SC/SCHOBES/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is for those of us that can't create Polish notation queries by 
hand, the IMAP::Query manpage can help you create them using a syntax inspired by other
query builder modules such as the SQL::Abstract manpage.

    use IMAP::Query qw(build_search_string);

    my $query = build_search_string(
        BEFORE => strftime('%%d-%%b-%%Y', localtime(parsedate('yesterday'))),
        NOT    => 'DELETED',
        -or    => [
            FROM => 'test@example.com',
            -and => [
                FROM    => 'other@example.com',
                SUBJECT => 'TESTING',
            ],
        ],
    );

    ... # Do something interesting with our $query
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/I*

%changelog
