# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/AIO.pm) perl(Test/More.pm) perl(base.pm) perl(common/sense.pm)
# END SourceDeps(oneline)
%define module_name IO-AIO-LoadLimited
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: A tiny IO::AIO extension that allows to load multiple files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UF/UFOBAT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use strict;
    use warnings;
    use IO::AIO;
    use IO::AIO::LoadLimited;

    my @pathnames = ( '/path/to/file', ...);
    my $group = aio_group sub { ... };
    my $limit = 10;
    aio_load_limited @pathnames, sub {
        my ($pathname, $content) = @_;

        warn "could not read $pathname: $!" unless defined $content;
        # whatever is neccessary...
        ...
    }, $group, $limit;

or

    aio_load_limited @pathnames, sub {
        my ($pathname, $content) = @_;

        warn "could not read $pathname: $!" unless defined $content;
        # whatever is neccessary...
        ...
    }, sub {
         # done cb
    };

    IO::AIO::flush; # or use AnyEvent::AIO
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/I*

%changelog
