%filter_from_requires /^perl.arybase.pm./d
%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/Pg.pm) perl(DBI.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Handle.pm) perl(Symbol.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.91
%define module_name IO-BLOB-Pg
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.91
Release: alt2
Summary: Emulate IO::File interface for PostgreSQL Large Objects
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MA/MAHEX/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The `IO::BLOB::Pg' module provide the `IO::File' interface for Large
Objects (aka BLOBs) in a PostgreSQL database.  An `IO::BLOB::Pg' object
can be attached to a Large Object ID, and will make it possible to use
the normal file operations for reading or writing data, as well as
seeking to various locations of the object.

This provides a tremendous amount of convenience since you can treat
the object just like a regular file and operate on it as you would
normally in Perl instead of doing all sorts of funky stuff like:

  $dbh->func($lobjfd, $buff, $len, "lo_read");

you get:

  <$lobjfd>

I based this code on Gisle Aas' IO::String.

The `IO::BLOB::Pg' module provides an interface compatible with
`IO::File' as distributed with IO-1.20, but the following methods
are not available; new_from_fd, fdopen, format_write,
format_page_number, format_lines_per_page, format_lines_left,
format_name, format_top_name.

The following methods are specific for the `IO::BLOB::Pg' class:

=over 4

=item $io = IO::BLOB::Pg->new( $dbh[, $objid] )

The constructor returns a newly created `IO::BLOB::Pg' object.  You
must supply it with a database handle.  It takes an optional argument
which is oid of the large objectto read from or write into.  If no
$objid argument is given, then a new large object is created.

The `IO::BLOB::Pg' object returned will be tied to itself.  This means
that you can use most perl IO builtins on it too; readline, <>, getc,
print, printf, syswrite, sysread, close.

=item $io->open( $dbh[, $objid] )

Attach an existing IO::BLOB::Pg object to some other $objid, or create
a new large object if no $objid is given.  The position is reset back
to 0.

=item $io->oid

This method will return the oid of the large object.  This is useful
for when you create a large object and what to put a reference to it
in another table.

=item $io->pad( [$char] )

The pad() method makes it possible to specify the padding to use if
the object is extended by either the truncate() method.  It
is a single character and defaults to "\0".

=item $io->pos( [$newpos] )

Yet another interface for reading and setting the current read/write
position within the object (the normal getpos/setpos/tell/seek
methods are also available).  The pos() method will always return the
old position, and if you pass it an argument it will set the new
position.

=item $io->length

Convenience method that gives you the size of the Blob.

=back

One more difference compared to IO::Handle, is that the write() and
syswrite() methods allow the length argument to be left out.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ChangeLog README
%perl_vendor_privlib/I*

%changelog
