# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Linux/Inotify2.pm)
# END SourceDeps(oneline)
%define module_name IO-BufferedSelect2
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1
Release: alt1
Summary: Line-buffered select interface with stream-reading facility
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CD/CDRAKE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Update of `IO::BufferedSelect' supporting "`tail -f'" facility (ability to 
read from files which might be growing, like logs etc). Uses `Linux::Inotify2'

The perl `select' and linux `inotify' system calls allow us to process
multiple streams simultaneously, blocking until one or more of them is ready for
reading or writing or when EOF is hit.  Unfortunately, this requires us to use
`sysread' and `syswrite' rather than Perl's buffered I/O functions.  In the 
case of reading, there are three issues with combining `select' with `readline':
(1) `select' might block but the data we want is already in Perl's input buffer,
ready to be slurped in by `readline'; (2) `select' might indicate that data is
available, but `readline' will block because there isn't a full `$/'-terminated
line available; and (3) `select' might not block (thus preventing us from
sleeping), even though there is no data to read (e.g. at `EOF', the end of a 
file, even if the file might be extended later) 

The purpose of this module is to implement a buffered version of the `select'
interface that operates on *lines*, rather than characters.  Given a set of
filehandles, it will block until a full line is available on one or more of
them.

Note that this module is currently limited, in that it only does `select'
for readability, not writability or exceptions. `$/' is the line separator.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/I*

%changelog
