%define module_version 0.003
%define module_name IO-Callback-HTTP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(Errno.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(IO/Callback.pm) perl(IO/Socket.pm) perl(LWP/UserAgent.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(URI.pm) perl(URI/Escape.pm) perl(base.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: read/write from HTTP URIs as if they were filehandles
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/IO-Callback-HTTP

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module allows you to read from and write to HTTP resources
as if they were normal file handles (in fact, any non-HTTP
resources supported by the LWP::UserAgent manpage ought to be OK too,
including FTP, Gopher, etc).

Why would you do this? Not for efficiency reasons, that's for
sure. However, certain APIs expect to be passed filehandles; this
module gives you those filehandles.

Files can be opened in either read mode, using:

 my $fh = IO::Callback::HTTP->new('<', $request, %%options);

or write mode:

 my $fh = IO::Callback::HTTP->new('>', $request, %%options);

The `$fh' variable will then act like a normal Perl filehandle,
but instead of interacting with a local file on disk, you'll be
interacting with an HTTP resource on a remote server.

`$request' can be a URI (either a string, or a blessed the URI manpage
object), or it can be an the HTTP::Request manpage object. A URI is
obviously simpler, but using an HTTP::Request object offers you
more flexibility, such as the ability to change the HTTP method
(defaults to GET for filehandles opened in read mode, and PUT for
filehandles opened in write mode) or include particular HTTP
headers (some of which are very useful: Accept, Content-Type,
User-Agent, etc).

Note that for a single filehandle, only one HTTP request is
actually made. In the case of read mode, this happens on the first
read. If no characters are read from the handle, then no request is
made. In the case of write mode, the request happens once the file
is closed.

There are also a few options which can be passed to the constructor:

=over

=item `agent'

An the LWP::UserAgent manpage object (or a subclass, such as
the WWW::Mechanize manpage or the LWPx::ParanoidAgent manpage) that will actually
make the request.

This is optional; IO::Callback::HTTP does have its own pet UA that
it can use if you don't provide one.

=item `bytes'

In read mode, if true, will make sure the data read from the handle
is returned encoded as a UTF-8 byte string. If false, then the data
read will be returned as a utf8 character string.

In write mode, if true, will assume that you're writing bytes to the
filehandle. If false, will assume that you're writing utf8 character
strings to the filehandle, so will deal with encoding them to UTF-8
octets.

Defaults to true.

=item `failure'

Set this to a coderef to trigger when the HTTP request fails (i.e.
times out or non-2XX HTTP response code). It is passed a single
parameter, which is the the HTTP::Response manpage object. 

As a shortcut, the strings 'croak', 'confess', 'carp' and 'cluck' are
also accepted, with the same meanings as defined in the Carp manpage.

Either way, IO::Callback::HTTP should do the correct thing, setting
`$!' and so on.

=item `success'

Set this to a coderef to trigger when the HTTP request succeeds
(i.e. 2XX HTTP response code). It is passed a single parameter, which
is the the HTTP::Response manpage object. 

For filehandles in read mode, this is probably not especially useful,
the fact that you can read from the file handle at all indicates that
the request was successful. In write mode, it's more interesting as
you may be interested in the result of a POST or PUT request.

=back

=begin private

=item open

=item USER_AGENT

=end private


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT LICENSE README Changes examples
%perl_vendor_privlib/I*

%changelog
