%define module_name IO-FD
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(AnyEvent.pm) perl(BSD/Resource.pm) perl(Export/These.pm) perl(ExtUtils/MakeMaker.pm) perl(constant/more.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3.11
Release: alt1
Summary: Faster accept, socket, listen with file descriptors, not handles
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DR/DRCLAW/%{module_name}-v%{version}.tar.gz

%description
IO::FD is an XS module implementing common core Perl system I/O functions to
work with file descriptors instead of Perl file handles. Functions
include but are not limited to `accept', `connect', `socket', `bind',
`sysopen', `sysread', and `syswrite'.

Many non core system functions such as `sendfile', `dup' and `mkstemp',
`pread', `pwrite', `mkfifo' which work with file descriptors are also
implemented.

Additional support for streamlined connection accepting is included via
`accept_multiple'.


This module can significantly lower memory usage per file descriptor and
decrease file/socket opening and socket accepting times.  `accept' performance
is particularly improved with much higher connection handling rates for a given
backlog.

Actual byte throughput (read/write) is basically unchanged compared to the core
Perl sysread/syswrite.  Please see the PERFORMANCE section later in this
document

The supported interfaces mostly resemble the core Perl implementations of similarly
named functions. 

For example:

_#Perl:
_sysopen(my $file_handle, ...);
_sysread($file_handle, ...);

_#IO::FD
_IO::FD::sysopen(my $file_descriptor, ...);
_IO::FD::sysread($file_descriptor, ...);

This modules IS NOT intended to be a drop in replacement for core IO
subroutines in existing code. If you want a 'drop in replacement' please look
at the IO::FD::DWIM manpage which is part of the same distribution.

Currently this module is focused on UNIX/Linux systems, as this is the natural
habitat of a file descriptor.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.md
%perl_vendor_archlib/I*
%perl_vendor_autolib/*

%changelog
