%define module_name IO-Framed
Epoch: 2
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(IO/SigGuard.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm) perl(Test/Simple.pm) perl(X/Tiny.pm) perl(autodie.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt1
Summary: Convenience wrapper for frame-based I/O
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FE/FELIPE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
While writing the Net::WAMP manpage I noticed that I was reimplementing some of the
same patterns I.e'd used in the Net::WebSocket manpage to parse frames from a stream:

=over

=item * Only read() entire frames, with a read queue for any partials.

=item * Continuance when a partial frame is delivered.

=item * Write queue with callbacks for non-blocking I/O

=item * Signal resilience: resume read/write after Perl receives a trapped
signal rather than throwing/giving EINTR. (cf. the IO::SigGuard manpage)

=back

These are now made available in this distribution.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/I*

%changelog
