%define module_name IO-Lambda
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(Authen/NTLM.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(Glib.pm) perl(Glib/Object/Introspection.pm) perl(HTTP/Cookies.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(IO/Socket/SSL.pm) perl(LWP.pm) perl(Net/DNS.pm) perl(POE.pm) perl(Prima.pm) perl(SNMP.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Sub/Name.pm) perl(Time/HiRes.pm) perl(URI.pm) perl(threads.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.34
Release: alt1
Summary: non-blocking I/O as lambda calculus
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KA/KARASIK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is another attempt to fight the horrors of non-blocking I/O.  It
tries to bring back the simplicity of the declarative programming style, that
is only available when one employs threads, coroutines, or co-processes.
Usually coding non-blocking I/O for single process, single thread programs
requires construction of state machines, often fairly complex, which fact
doesn't help the code clarity, and is the reason why the asynchronous I/O
programming is often considered 'messy'. Similar to the concept of monads in
functional languages, that enforce a certain order of execution over generally
orderless functions, `IO::Lambda' allows writing I/O callbacks in a style that
resembles the good old sequential, declarative programming.

The manual begins with code examples, then proceeds to explaining basic
assumptions, then finally gets to the complex concepts, where the real fun
begins. You can skip directly there (the Stream IO entry elsewhere in this document, the Higher-order functions entry elsewhere in this document),
where the functional style mixes with I/O. If, on the contrary, you are
intimidated by the module's ambitions, you can skip to the Simple use entry elsewhere in this document for a more
gentle introduction. Those, who are interested how the module is different from
the other I/O frameworks, please continue reading.

Warning: API in version 1.01 has slightly changed. See the IO::Lambda::Compat manpage
for dealing with program written usign the older API.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/I*

%changelog
