# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Lingua/EN/Inflect.pm) perl(Test/Kwalitee.pm) perl(Test/Perl/Critic.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    IO-Prompt-Hooked
%define upstream_version 0.10

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_9

Summary:    Simple prompting with validation hooks
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/IO/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Capture/Tiny.pm)
BuildRequires: perl(English.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(IO/Prompt/Tiny.pm)
BuildRequires: perl(Params/Smart.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(parent.pm)
BuildArch:  noarch
Source44: import.info

%description
IO::Prompt::Tiny is a nice module to use for basic prompting. It properly
detects interactive sessions, and since it's based on the 'prompt()'
routine from the ExtUtils::MakeMaker manpage, it's highly portable.

But the IO::Prompt::Tiny manpage is intentionally minimal. Often one begins
wrapping it in logic to validate input, retry on invalid, limit number of
attempts, and alert the user to invalid input. the IO::Prompt::Hooked
manpage adds simple validation, attempt limiting, and error handling to
IO::Prompt::Tiny's minimalism. It does this by allowing you to supply
simple Regexp objects for validation, or subroutine callbacks if you need
finer control.

"But we already have the IO::Prompt manpage for non-trivial needs.", you
might be thinking. And you're right. But have you read its POD? It's far
from being simple, and is not as portable as this module. the
IO::Prompt::Hooked manpage aims to provide the portability of IO::Tiny, and
easy to use hooks for input validation.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README examples
%perl_vendor_privlib/*

%changelog
