%define module_name IO-ReadPreProcess
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DirHandle.pm) perl(Errno.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(IO/Pipe.pm) perl(Math/Expression.pm) perl(Test/More.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.85
Release: alt1
Summary: Macro processing built into IO::File replacement
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AD/ADDW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Provide an 'intelligent' bottom end read function for scripts,
what is read is pre-processed before the script sees it.
Your program does not need code to conditionally discard some input, include
files and substitute values.

An easy way of reading input where some lines are read conditionally and other
files included: .if/.else/.elseif/.fi, do: .include .let .print, loops: .while
.for; subroutine definition & call - and more.

Provides IO::Handle-ish functions and input diamond - thus easy to slot in to existing scripts.

The preprocessing layer has variables that can be set and read by your perl code.
In the input files they are set via `.let' directives, and can be made part of your
script's input with `.echo' and `\v{xxx}'.

`IO::ReadPreProcess' returns lines from the input stream.
This may have directives that include:

=over 4

=item

set variables to arithmetic or string expressions

=item

conditionally return lines

=item

include other files

=item

print to stdout or stderr

=back

Conditions are done by `Math::Expression'.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/I*

%changelog
