# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm)
# END SourceDeps(oneline)
%define module_name IO-Socket-TIPC
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.09
Release: alt4
Summary: TIPC sockets for Perl
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IN/INFINOID/%{module_name}-%{version}.tar.gz

%description
TIPC stands for Transparent Inter-Process Communication.  See
http://tipc.sf.net/ for details.

This perl module subclasses IO::Socket, in order to use TIPC sockets
in the customary (and convenient) Perl fashion.

TIPC supports 4 types of socket: *SOCK_STREAM*, *SOCK_SEQPACKET*,
*SOCK_RDM* and *SOCK_DGRAM*.  These are all available through this
perl API, though the usage varies depending on which kind of socket
you use.

*SOCK_STREAM* and *SOCK_SEQPACKET* are connection-based sockets.
These sockets are strictly client/server.  For servers, new() will
call bind() for you, to bind to a *Local** name, and you then
accept() connections from clients, each of which get their own
socket (returned from accept).  For clients, new() will call
connect() for you, to connect to the specified *Peer** name, and
once that succeeds, you can do I/O on the socket directly.  In this
respect, usage details are very similar to *TCP* over *IPv4*.

See the EXAMPLES section, for an example of connection-based socket
use.

*SOCK_RDM* and *SOCK_DGRAM* are connectionless sockets.  You cannot
use the normal send/recv/print/getline methods on them, because the
network stack will not know which host on the network to send or
receive from.  Instead, once you have called new() to create the
socket, you use sendto and recvfrom to send and receive
individual packets to/from a specified peer, indicated using an
IO::Socket::TIPC::Sockaddr class object.

Connectionless sockets (*SOCK_RDM* and *SOCK_DGRAM*) are often
bind()ed to a particular *Name* or *Nameseq* address, in order to
allow them to listen for packets sent to a well-known destination
(the *Name*).  You can use *LocalName* or *LocalNameseq* parameters
to new(), to select a name or name-sequence to bind to.  As above,
these parameters internally become *Name* and *Nameseq* arguments to
IO::Socket::TIPC::Sockaddr->new(), and the result is passed to
bind().  This is very similar to typical uses of *UDP* over
*IPv4*.

Since connectionless sockets are not linked to a particular peer, yo...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO Changes README examples
%perl_vendor_archlib/I*
%perl_vendor_autolib/*

%changelog
