%define module_name IO-Stream-HTTP-Persistent
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Alias.pm) perl(EV.pm) perl(File/Temp.pm) perl(IO/Stream.pm) perl(IO/Stream/const.pm) perl(Module/Build/Tiny.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.2
Release: alt1
Summary: HTTP persistent connections plugin
Group: Development/Perl
License: mit
URL: https://github.com/powerman/perl-IO-Stream-HTTP-Persistent

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POWERMAN/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module is plugin for the IO::Stream manpage which allow you to process
complete HTTP requests and responses read/written by this stream.
It's useful only for persistent HTTP connections (HTTP/1.0 with Keep-Alive
and HTTP/1.1).

On usual HTTP/1.0 non-persistent connections it's ease to detect sent HTTP
request using SENT event and received HTTP response using EOF event.
But on persistent connections that's become much more complicated: to
detect end of single received HTTP response (or boundaries between several
received responses) you have to parse HTTP protocol, and when HTTP/1.1
Pipelining is used it's not easy to find out how many complete requests
was already sent.

This module will parse HTTP protocol for sent and received data, and will
generate non-standard events HTTP_SENT and HTTP_RECV when one or more
complete HTTP requests will be sent or HTTP responses received.
It will provide you with list of sizes for each sent request and received
response, which make it ease to find how many requests was sent or get
separate responses from {in_buf}.



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/I*

%changelog
