%define module_name IO-Uring
# BEGIN SourceDeps(oneline):
BuildRequires: liburing-devel perl(Alien/liburing.pm) perl(Dist/Build.pm) perl(Dist/Build/XS.pm) perl(Dist/Build/XS/Alien.pm) perl(Exporter.pm) perl(ExtUtils/Builder/ParseXS.pm) perl(ExtUtils/ParseXS.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Socket.pm) perl(Test/More.pm) perl(XSLoader.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: io_uring for Perl
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LE/LEONT/%{module_name}-%{version}.tar.gz

%description
This module is a low-level interface to `io_uring', Linux's new asynchronous I/O interface drastically reducing the number of system calls needed to perform I/O. Unlike previous models such as epoll, it's based on a proactor model instead of a reactor model, meaning that you schedule asynchronous actions and then get notified by a callback when the action has completed.

Generally speaking, the methods of this class match a system call 1-to-1 (e.g. the recv(2) manpage), except that they have two additional arguments:

=over 1

=item 1.

The submission flags. In particular this allows you to chain actions.

=item 2.

A callback. This callback receives two integer arguments: a result (on error typically a negative errno value), and the completion flags. This callback will be kept alive by this module; any other resources that need to be kept alive should be captured by it.

=back

All event methods return an identifier that can be used with `cancel'.

Note: This is an early release and this module should still be regarded as experimental. Backwards compatibility is not yet guaranteed.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README examples
%perl_vendor_archlib/I*
%perl_vendor_autolib/*

%changelog
