%define module_version 0.110
%define module_name IO-Vectored
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.110
Release: alt7
Summary: Read from or write to multiple buffers at once
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FR/FRACTAL/%{module_name}-%{module_version}.tar.gz
# TODO: fix compilation on other arches
ExclusiveArch:x86_64

%description
Vectored-IO is sometimes called "scatter-gather" IO. The idea is that instead of doing multiple `read(2)' or `write(2)' system calls for each string, your program creates a vector of pointers to all the strings you wish to read/write and then does a single system call referencing this vector.

Although some people consider these interfaces contrary to the minimalist design principles of unix, vectored-IO has certain advantages which are described below.

This module is an interface to your system's readv(2) and writev(2) vectored-IO system calls specified by POSIX.1. It exports the functions `syswritev' and `sysreadv' which are almost the same as the `syswrite' and `sysread' perl functions except that they accept multiple strings and always have default length and offset parameters.




%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/I*
%perl_vendor_autolib/*

%changelog
