%define module_name IPC-Concurrency-DBI
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Data/Dumper.pm) perl(Data/Validate/Type.pm) perl(Module/Build.pm) perl(Test/Exception.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2.0
Release: alt1
Summary: Control how many instances of an application run in parallel, using DBI as the IPC method.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/IPC-Concurrency-DBI

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AU/AUBERTG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module controls how many instances of a given program are allowed to run
in parallel. It does not manage forking or starting those instances.

You can use this module for example to prevent more than one instance of a
program from running at any given time, or to never have more than N instances
running in parallel to prevent exhausting all the available resources.

It uses DBI as a storage layer for information about instances and applications,
which is particularly useful in contexts where Sarbanes-Oxley regulations allow
you database access but not file write rights in production environments.

_# Configure the concurrency object.
_use IPC::Concurrency::DBI;
_my $concurrency_manager = IPC::Concurrency::DBI->new(
__'database_handle' => $dbh,
__'verbose'         => 1,
_);

_# Create the tables that the concurrency manager needs to store information
_# about the applications and instances.
_$concurrency_manager->create_tables();

_# Register cron_script.pl as an application we want to limit to 10 parallel
_# instances. We only need to do this once, obviously.
_$concurrency_manager->register_application(
__name              => 'cron_script.pl',
__maximum_instances => 10,
_);

_# Retrieve the application.
_my $application = $concurrency_manager->get_application(
__name => 'cron_script.pl',
_);

_# Count how many instances are currently running.
_my $instances_count = $application->get_instances_count();

_# NOT IMPLEMENTED YET: Get a list of what instances are currently running.
_# my $instances = $application->get_instances_list()

_# Start a new instance of the application. If this returns undef, we've
_# reached the limit.
_unless ( my $instance = $application->start_instance() )
_{
__print "Too many instances of $0 are already running.\n";
__exit;
_}

_# [...] Do some work.

_# Now that the application is about to exit, flag the instance as completed.
_# (note: this is implicit when $instance is destroyed).
_$instance->finish();



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes ignore.txt README.md LICENSE examples
%perl_vendor_privlib/I*

%changelog
