# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(Symbol.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    IPC-Pipeline
%define upstream_version 1.0

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Create a shell-like pipeline of many running commands
License:    GPLv1+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/IPC/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
Similar in calling convention to IPC::Open3, pipeline() spawns N children,
connecting the first child to the FIRST_CHLD_IN handle, the final child to
LAST_CHLD_OUT, and each child to a shared standard error handle,
CHILDREN_ERR. Each subsequent filter specified causes a new process to be
fork()ed. Each process is linked to the last with a file descriptor pair
created by pipe(), using dup2() to chain each process' standard input to
the last standard output.

FEATURES
    IPC::Pipeline accepts external commands to be executed in the form of
    ARRAY references containing the command name and each argument, as well
    as CODE references that are executed within their own processes as
    well, each as independent parts of a pipeline.

    ARRAY REFS
        When a filter is passed in the form of an ARRAY containing an
        external system command, each such item is executed in its own
        subprocess in the following manner.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc COPYRIGHT Changes LICENSE META.json META.yml 
%perl_vendor_privlib/*

%changelog
