%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FileHandle.pm) perl(IPC/Open3.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name IPC-Session
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Drive ssh or other interactive shell, local or remote (like 'expect')
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/ST/STEVEGT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module encapsulates the open3() function call (see the IPC::Open3 manpage)
and its associated filehandles.  This makes it easy to maintain
multiple interactive command sessions, such as multiple persistent
'ssh' and/or 'rsh' sessions, within the same perl script.  

The remote shell session is kept open for the life of the object; this
avoids the overhead of repeatedly opening remote shells via multiple
ssh or rsh calls.  This persistence is particularly useful if you are 
using ssh for your remote shell invocation; it helps you overcome 
the high ssh startup time.

For applications requiring remote command invocation, this module 
provides functionality that is similar to 'expect' or Expect.pm,
but in a lightweight more Perlish package, with discrete STDOUT, 
STDERR, and return code processing.

By the way, there's nothing inherently ssh-ish about IPC::Session -- it
doesn't even know anything about ssh, as a matter of fact.  It will
work with any interactive shell that supports 'echo'.  For instance,
'make test' just drives a local /bin/sh session.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ChangeLog
%perl_vendor_privlib/I*

%changelog
