%def_without test
%define module_name Image-Animated-JPEG
BuildRequires: xvfb-run
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Data/HexDump.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Scalar.pm) perl(IO/String.pm) perl(IPC/System/Simple.pm) perl(Image/MetaData/JPEG.pm) perl(Path/Tiny.pm) perl(Pod/Usage.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Wx.pm) perl(Wx/Event.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Library and scripts to create, play and modify Animated JPEG files
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CL/CLIPLAND/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides functions to handle Animated JPEG files (AJPEGs), which are
similar to Motion-JPEG files, as they are just a concatenation of JPEGs.

The proposed Animated JPEG standard utilises JPEG/JFIF's APP0 application
extension segments to store playback settings, e.g. frame-rate (delay), loop
behaviour (repeat), etc., JFIF compliant as an additional APP0 marker. This
way, MJPEG files become a self-contained animation file similar to animated GIF
files.

The routines found in this module are able to index frames within an AJPEG file,
to process single frames in order to extract APP0 markers, and it provides
functions to encode and read segments in Animated JPEG's proposed segment data
format, version 0.

Also, this distribution comes bundled with five Animated JPEG utility scripts
which employ this module's routines to create, transform and play AJPEG files:

=over

=item * makeajpeg - script to create Animated JPEG files on command-line.

=item * playajpeg - a WxPerl-based Animated JPEG player GUI application.

=item * gif2ajpeg - utilizes ImageMagick's *convert* and *makeani* to
convert animated gif files to Animated JPEG files.

=item * ajpeg2gif - uses *makeajpeg* to assemble and animated GIF from
an animated JPEG.

=item * ajpegtran - lossless cropping of an entire animated JPEG animation
by executing *jpegtran* on every separate frame.

=back

If you are interested in details of the proposed AJPEG format, the Why and How,
then read the README and SPECIFICATIONS files bundled with this distribution.

Also, the README file provides further information on how to set MIME-Type, etc.
on a *nix system so *.ajpeg* files get associated with *playajpeg*.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%{expand:%%global __find_requires xvfb-run -a %__find_requires}

%files
%doc LICENSE SPECIFICATIONS.md Changes README
%perl_vendor_privlib/I*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
